<?php 
/**
 * Examiner page
**/ 
?>
<?php get_header(); ?>

<div id="main">
	<?php woocommerce_demo_store(); ?>
<div id="primary">
	<?php woocommerce_content(); ?>
</div>
<div id="secondary" class="widget-area <?php echo esc_html(get_option('exm1_last_widget_sticky'));?>">
	<?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('Woocommerce Sidebar')): endif; ?>
</div>
<!--secondary-->

<div class="fullwidth">
	<div class="home-widget four-parts">
		<h3>
			<span class="widget-title">
			Top Rated Products
			</span>
		</h3>
		<div class="jumping-posts">
			<ul>
				<?php
			add_filter( 'posts_clauses',  array( WC()->query, 'order_by_rating_post_clauses' ) );
            $args = array( 'post_type' => 'product', 'stock' => 1, 'posts_per_page' => 4, 'order' => 'ASC' );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post(); global $product; ?>
				<li>
					<div class="jumping-posts-image">
						<a id="id-<?php the_id(); ?>" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
						<?php if (has_post_thumbnail( $loop->post->ID )) echo get_the_post_thumbnail($loop->post->ID, 'jumping-posts-thumb');?>
					</div>
					</a>
					<div class="jumping-posts-text">
						<div class="jumping-posts-category">
							<?php echo wp_kses_post($product->get_rating_html()); ?>
						</div>				
						<div class="jumping-posts-title">
							<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
							<?php echo wp_trim_words( get_the_title(), 7 ); ?>
							</a>
						</div>
						<!--jumping-posts-title-->
						<div class="jumping-posts-excerpt">
							<?php echo excerpt(30); ?>
						</div>
						<!--jumping-posts-excerpt-->
					</div>
					<!--jumping-posts-text-->			
				</li>
				<?php endwhile; ?>
			</ul>
		</div>
	</div>
</div>
<?php get_footer(); ?>