<?php 
/**
 * Examiner meta-fields
**/ 
?>
<?php

//============Video link meta field=================

add_action ( 'load-post.php', 'exm1metabox' );
add_action ( 'load-post-new.php', 'exm1metabox' );

// Meta box setup function.

function exm1metabox() {
	add_action ( 'add_meta_boxes', 'exm1_add_post_meta' );
	add_action ( 'save_post', 'exm1_save_post_meta', 10, 2 );
}

//Display meta box.

function exm1_add_post_meta() {
	add_meta_box ( 'exm1-video-link', __('Featured Video','examiner'), 'exm1_video_link_box', 'post', 'normal', 'high' );
}

function exm1_video_link_box($object, $box) {wp_nonce_field( basename( __FILE__ ), 'exm1_video_link_nonce' ); ?>

<p>
	<label for="exm1-video-link">
		<?php _e('Paste a link from Vimeo or Youtube, it will be embeded in the post.', 'examiner'); ?>
	</label>
	<input class="widefat" type="text" name="exm1-video-link" id="exm1-video-link" value="<?php echo esc_textarea(get_post_meta( $object->ID, 'exm1_video_link', true )); ?>"size="30" />
</p>

<?php
}

//Save the metabox value.

function exm1_save_post_meta($post_id, $post) {
	if (! isset ( $_POST ['exm1_video_link_nonce'] ) || ! wp_verify_nonce ( $_POST ['exm1_video_link_nonce'], basename ( __FILE__ ) ))
		return $post_id;
	$post_type = get_post_type_object ( $post->post_type );
	if (! current_user_can ( $post_type->cap->edit_post, $post_id ))
		return $post_id;
	$new_meta_value = (isset ( $_POST ['exm1-video-link'] ) ? balanceTags ( $_POST ['exm1-video-link'] ) : '');
	$meta_key = 'exm1_video_link';
	$meta_value = get_post_meta ( $post_id, $meta_key, true );
	if ($new_meta_value && '' == $meta_value)
		add_post_meta ( $post_id, $meta_key, $new_meta_value, true );
	elseif ($new_meta_value && $new_meta_value != $meta_value)
		update_post_meta ( $post_id, $meta_key, $new_meta_value );
	elseif ('' == $new_meta_value && $meta_value)
		delete_post_meta ( $post_id, $meta_key, $meta_value );
}


function user_social_profile_fields($user) {
	
//================Author social links=================
	
	?>
<h3>
	<?php __('Social Profiles', 'examiner'); ?>
</h3>
<table class="form-table">
	<tr>
		<th><label for="twitter">
				<?php _e('Twitter', 'examiner'); ?>
			</label></th>
		<td><input type="text" name="twitter" id="twitter" value="<?php echo esc_textarea(get_the_author_meta( 'twitter', $user->ID )); ?>" class="regular-text" /></td>
	</tr>
	<tr>
		<th><label for="facebook">
				<?php _e('Facebook', 'examiner'); ?>
			</label></th>
		<td><input type="text" name="facebook" id="facebook" value="<?php echo esc_textarea(get_the_author_meta( 'facebook', $user->ID  )); ?>" class="regular-text" /></td>
	</tr>
	<tr>
		<th><label for="google">
				<?php _e('Google+', 'examiner'); ?>
			</label></th>
		<td><input type="text" name="google" id="google" value="<?php echo esc_textarea(get_the_author_meta( 'google', $user->ID  )); ?>" class="regular-text" /></td>
	</tr>
  <tr>
    <th><label for="linkedin">
        <?php _e('Linkedin', 'examiner'); ?>
      </label></th>
    <td><input type="text" name="linkedin" id="linkedin" value="<?php echo esc_textarea(get_the_author_meta( 'linkedin', $user->ID  )); ?>" class="regular-text" /></td>
  </tr>
	<tr>
		<th><label for="whatsapp">
				<?php _e('WhatsApp', 'examiner'); ?>
			</label></th>
		<td><input type="text" name="pinterest" id="pinterest" value="<?php echo esc_textarea(get_the_author_meta( 'pinterest', $user->ID )); ?>" class="regular-text" /></td>
	</tr>
	<tr>
		<th><label for="instagram">
				<?php _e('Instagram', 'examiner'); ?>
			</label></th>
		<td><input type="text" name="instagram" id="instagram" value="<?php echo esc_textarea(get_the_author_meta( 'instagram', $user->ID  )); ?>" class="regular-text" /></td>
	</tr>
</table>
<?php
}
function save_user_social_profile_fields($user_id) {
	
//Save the metabox value.

	if (! current_user_can ( 'edit_user', $user_id ))
		return false;
	
	update_user_meta ( $user_id, 'twitter', $_POST ['twitter'] );
	update_user_meta ( $user_id, 'facebook', $_POST ['facebook'] );
	update_user_meta ( $user_id, 'google', $_POST ['google'] );
  update_user_meta ( $user_id, 'linkedin', $_POST ['linkedin'] );
	update_user_meta ( $user_id, 'pinterest', $_POST ['pinterest'] );
	update_user_meta ( $user_id, 'instagram', $_POST ['instagram'] );
}
add_action ( 'show_user_profile', 'user_social_profile_fields' );
add_action ( 'edit_user_profile', 'user_social_profile_fields' );

add_action ( 'personal_options_update', 'save_user_social_profile_fields' );
add_action ( 'edit_user_profile_update', 'save_user_social_profile_fields' );

//==================Subtitle====================

    add_action( 'edit_form_after_title', 'exm1_subtitle_meta_box' );
    add_action( 'save_post', 'exm1_save_subtitle_meta_box', 10, 2 );

function exm1_subtitle_meta_box( $object ) { ?>
<?php if( 'post' == $object->post_type || 'page' == $object->post_type) {?>
        <label><?php _e('(optional)Please enter sub title or favorite quote from the text:', 'examiner'); ?></label>
        <input name="exm1_sub_title" id="sw_title" style="width: 100%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'exm1_sub_title', true ), 1 ); ?>" />
        <input type="hidden" name="my_meta_box_nonce" value="<?php echo wp_create_nonce( basename( __FILE__ ) ); ?>" />

<?php }}

function exm1_save_subtitle_meta_box( $post_id, $post ) {

    if (! isset ( $_POST ['my_meta_box_nonce'] ) || !wp_verify_nonce( $_POST['my_meta_box_nonce'] , basename( __FILE__ ) ) )
        return $post_id;

    if ( !current_user_can( 'edit_post', $post_id ) )
        return $post_id;

    //Saving 1st Data
    
    $meta_value = get_post_meta( $post_id, 'exm1_sub_title', true );
    $new_meta_value = stripslashes( $_POST['exm1_sub_title'] );

    if ( $new_meta_value && '' == $meta_value )
        add_post_meta( $post_id, 'exm1_sub_title', $new_meta_value, true );

    elseif ( $new_meta_value != $meta_value )
        update_post_meta( $post_id, 'exm1_sub_title', $new_meta_value );

    elseif ( '' == $new_meta_value && $meta_value )
        delete_post_meta( $post_id, 'exm1_sub_title', $meta_value ); 
}
function exm1_subtitle() {
		global $post;
		echo esc_html(get_post_meta($post->ID, 'exm1_sub_title', true));
}



//=======Review metabox===========

// Adds a box to the Posts edit screens. 
add_action( 'add_meta_boxes_post', 'exm1_review_add_meta_boxes' );

// Saves the meta box custom data. 
add_action( 'save_post', 'exm1_review_save_postdata', 10, 2 );

//Adds a box to the Post edit screens.
function exm1_review_add_meta_boxes() {
    $post_types = get_post_types( array('public' => true), 'names' );
    $excluded_post_types = array('attachment');
    
    foreach ($post_types as $post_type) {
        if (!in_array($post_type, $excluded_post_types)) {
		
        	add_meta_box(
        		'exm1-review-metabox',
        		__('Review Item', 'examiner'),
        		'exm1_review_render_meta_box',
        		$post_type,
        		'normal',
        		'high'
        	);
        }
    }
}


//Render the meta box.

 
function exm1_review_render_meta_box( $post ) {
	
// Retrieve an existing value from the database.
	$heading = get_post_meta( $post->ID, 'exm1_review_heading', true );
	$image = get_post_meta( $post->ID, 'exm1_review_image', true );
	
	
	
	
	
	$good = get_post_meta( $post->ID, 'exm1_review_good', true );
	
	$goodCriteria = apply_filters('exm1_review_good_criteria', array());
    $goodItems = array();
    foreach ($goodCriteria as $item) {
        $goodItems[] = array( 'exm1_review_good' => $item);
    }
		
	$bad = get_post_meta( $post->ID, 'exm1_review_bad', true );

	$badCriteria = apply_filters('exm1_review_bad_criteria', array());
    $badItems = array();
    foreach ($badCriteria as $item) {
        $badItems[] = array( 'exm1_review_bad' => $item);
    }

	$defaultCriteria = apply_filters('exm1_review_default_criteria', array());
    $defaultItems = array();
    foreach ($defaultCriteria as $item) {
        $defaultItems[] = array( 'exm1_review_item_title' => $item, 'exm1_review_item_score' => '');
    }
	$items     = get_post_meta( $post->ID, 'exm1_review_item', true );
	
	
	
	
	if ( $items == '' ) $items = $defaultItems; 
    
// Add an nonce field so we can check for it later.
	wp_nonce_field( basename( __FILE__ ), 'exm1-review-item-nonce' );
	wp_nonce_field( basename( __FILE__ ), 'exm1-review-heading-nonce' );
	wp_nonce_field( basename( __FILE__ ), 'exm1-review-image-nonce' );
	wp_nonce_field( basename( __FILE__ ), 'exm1-review-bad-nonce' );
	wp_nonce_field( basename( __FILE__ ), 'exm1-review-good-nonce' );
	
?>
<p class="exm1-review-field">
    <div id="post-review-title"><?php _e('Review Item Title', 'examiner'); ?></div>
    <input type="text" name="exm1_review_heading" id="exm1_review_heading" value="<?php echo esc_textarea($heading); ?>" />
</p>
<p class="exm1-image-field">
<div id="exm1-image-preview-title"><?php _e('Image Selection', 'examiner'); ?></div>
<input type="text" name="exm1_review_image" id="exm1_review_image" value="<?php echo esc_attr($image); ?>"/>
<input type= "button" class="button" name="image_button" id="image_button" value="Choose Image" />
</p>


<div class="exm1-image-preview-wrapper">
    <div id="exm1-image-preview-title"><?php _e('Preview Image', 'examiner'); ?></div>
	<img class="exm1-image-preview" src="<?php echo esc_url($image); ?>" width="100%">
</div>



<div class="exm1-good-wrapper">
<!-- Start repeater field good -->
<table id="exm1-review-good" class="exm1-review-good" width="100%">
  <thead>
    <tr>
      <th width="100%"><?php _e('Good', 'examiner'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php if ( !empty($good) ) : ?>
    <?php foreach ( $good as $item ) { ?>
    <tr>
      <td><input type="text" class="widefat" name="exm1_review_good[]" value="<?php if( !empty( $item['exm1_review_good'] ) ) echo esc_textarea($item['exm1_review_good']); ?>" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
    <?php } ?>
    <?php else : ?>
    <tr>
      <td><input type="text" class="widefat" name="exm1_review_good[]" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
    <?php endif; ?>
    
    <!-- empty hidden -->
    <tr class="empty-row screen-reader-text good">
      <td><input type="text" class="widefat" name="exm1_review_good[]" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
  </tbody>
</table>
<table width="40%">
  <tr>
    <td width="80%"><a id="add-row-good" class="button" href="#">
      <?php _e('Add another','examiner'); ?>
      </a></td>
  </tr>
</table>
</div>

<div class="exm1-bad-wrapper">
<!-- Start repeater field bad -->
<table id="exm1-review-bad" class="exm1-review-bad" width="100%">
  <thead>
    <tr>
      <th width="100%"><?php _e('bad','examiner'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php if ( !empty($bad) ) : ?>
    <?php foreach ( $bad as $item ) { ?>
    <tr>
      <td><input type="text" class="widefat" name="exm1_review_bad[]" value="<?php if( !empty( $item['exm1_review_bad'] ) ) echo esc_textarea($item['exm1_review_bad']) ; ?>" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
    <?php } ?>
    <?php else : ?>
    <tr>
      <td><input type="text" class="widefat" name="exm1_review_bad[]" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
    <?php endif; ?>
    
    <!-- empty hidden -->
    <tr class="empty-row screen-reader-text bad">
      <td><input type="text" class="widefat" name="exm1_review_bad[]" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
  </tbody>
</table>
<table width="100%">
  <tr>
    <td width="80%"><a id="add-row-bad" class="button" href="#">
       <?php _e('Add another','examiner'); ?>
      </a></td>
  </tr>
</table>
</div>

<!-- Start repeater field -->
<table id="exm1-review-item" class="exm1-review-item" width="100%">
  <thead>
    <tr>
      <th width="80%"><?php _e('Feature Name', 'examiner'); ?></th>
      <th width="10%" class="dynamic-text"><?php _e('Score (1-10)','examiner'); ?></th>
      <th width="10%"></th>
    </tr>
  </thead>
  <tbody>
    <?php if ( !empty($items) ) : ?>
    <?php foreach ( $items as $item ) { ?>
    <tr>
      <td><input type="text" class="widefat" name="exm1_review_item_title[]" value="<?php if( !empty( $item['exm1_review_item_title'] ) ) echo esc_textarea($item['exm1_review_item_title']) ; ?>" /></td>
      <td><input type="text" min="1" step="1" autocomplete="off" class="widefat review-score" name="exm1_review_item_score[]" value="<?php if ( !empty ($item['exm1_review_item_score'] ) ) echo esc_textarea($item['exm1_review_item_score']); ?>" /></td>
      <td><a class="button remove-row" href="#">
       <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
    <?php } ?>
    <?php else : ?>
    <tr>
      <td><input type="text" class="widefat" name="exm1_review_item_title[]" /></td>
      <td><input type="text" min="1" step="1" autocomplete="off" class="widefat review-score" name="exm1_review_item_score[]" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
    <?php endif; ?>
    
    <!-- empty hidden -->
    <tr class="empty-row screen-reader-text scores">
      <td><input type="text" class="widefat" name="exm1_review_item_title[]" /></td>
      <td><input type="text" min="1" step="1" autocomplete="off" class="widefat" name="exm1_review_item_score[]" /></td>
      <td><a class="button remove-row" href="#">
        <?php _e('Delete', 'examiner'); ?>
        </a></td>
    </tr>
  </tbody>
</table>
<table width="100%">
  <tr>
    <td width="80%"><a id="add-row" class="button" href="#">
     <?php _e('Add another','examiner'); ?>
      </a></td>
    <td width="10%"><input type="text" class="widefat exm1-review-total" name="exm1_review_total" value="<?php echo esc_attr(get_post_meta( $post->ID, 'exm1_review_total', true )); ?>" readonly /></td>
    <td width="10%"><?php _e('Total', 'examiner'); ?></td>
  </tr>
</table>

<?php
}


	// Saves the meta box.

function exm1_review_save_postdata( $post_id, $post ) {

	if ( !isset( $_POST['exm1-review-item-nonce'] ) || !wp_verify_nonce( $_POST['exm1-review-item-nonce'], basename( __FILE__ ) ) )
		return;

	if ( !isset( $_POST['exm1-review-heading-nonce'] ) || !wp_verify_nonce( $_POST['exm1-review-heading-nonce'], basename( __FILE__ ) ) )
		return;
		
	if ( !isset( $_POST['exm1-review-image-nonce'] ) || !wp_verify_nonce( $_POST['exm1-review-image-nonce'], basename( __FILE__ ) ) )
		return;
		
	if ( !isset( $_POST['exm1-review-good-nonce'] ) || !wp_verify_nonce( $_POST['exm1-review-good-nonce'], basename( __FILE__ ) ) )
		return;
		
	if ( !isset( $_POST['exm1-review-bad-nonce'] ) || !wp_verify_nonce( $_POST['exm1-review-bad-nonce'], basename( __FILE__ ) ) )
		return;

	// If this is an autosave, our form has not been submitted, so we don't want to do anything. 
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
		return $post_id;

	// Check the user's permissions.
	if ( 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) )
			return $post_id;
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) )
			return $post_id;
	}

	$meta = array(

		'exm1_review_total'    => $_POST['exm1_review_total'],
		'exm1_review_heading'     => $_POST['exm1_review_heading'],
		'exm1_review_image'     => $_POST['exm1_review_image'],
	);

	foreach ( $meta as $meta_key => $new_meta_value ) {

		// Get the meta value of the custom field key. 4
		$meta_value = get_post_meta( $post_id, $meta_key, true );

		//If there is no new meta value but an old value exists, delete it.
		if ( current_user_can( 'delete_post_meta', $post_id, $meta_key ) && '' == $new_meta_value && $meta_value )
			delete_post_meta( $post_id, $meta_key, $meta_value );

		// If a new meta value was added and there was no previous value, add it. 
		elseif ( current_user_can( 'add_post_meta', $post_id, $meta_key ) && $new_meta_value && '' == $meta_value )
			add_post_meta( $post_id, $meta_key, $new_meta_value, true );

		// If the new meta value does not match the old value, update it. 
		elseif ( current_user_can( 'edit_post_meta', $post_id, $meta_key ) && $new_meta_value && $new_meta_value != $meta_value )
			update_post_meta( $post_id, $meta_key, $new_meta_value );
	}

	// Repeatable update and delete meta fields method.
	$title = $_POST['exm1_review_item_title'];
	$score  = $_POST['exm1_review_item_score'];

	$old   = get_post_meta( $post_id, 'exm1_review_item', true );
	$new   = array();

	$count = count( $title );
	
	for ( $i = 0; $i < $count; $i++ ) {
		if ( $title[$i] != '' )
			$new[$i]['exm1_review_item_title'] = sanitize_text_field( $title[$i] );
		if ( $score[$i] != '' )
			$new[$i]['exm1_review_item_score'] = sanitize_text_field( $score[$i] );
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'exm1_review_item', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'exm1_review_item', $old );
		
		
	// Repeatable field Good.
	$good = $_POST['exm1_review_good'];
	$old   = get_post_meta( $post_id, 'exm1_review_good', true );
	$new   = array();

	$count = count( $good );
	
	for ( $i = 0; $i < $count; $i++ ) {
		if ( $good[$i] != '' )
			$new[$i]['exm1_review_good'] = sanitize_text_field( $good[$i] );
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'exm1_review_good', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'exm1_review_good', $old );
		
		
	//Repeatable field Bad.
	$bad = $_POST['exm1_review_bad'];
	$old   = get_post_meta( $post_id, 'exm1_review_bad', true );
	$new   = array();

	$count = count( $bad );
	
	for ( $i = 0; $i < $count; $i++ ) {
		if ( $bad[$i] != '' )
			$new[$i]['exm1_review_bad'] = sanitize_text_field( $bad[$i] );
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'exm1_review_bad', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'exm1_review_bad', $old );

}

function review_scripts($hook) {
	if ( $hook == 'post-new.php' || $hook == 'post.php' ) {
			wp_enqueue_script('exm1review', get_template_directory_uri() . '/js/exm1-post.js', array('jquery'));
			wp_enqueue_style( 'exm1-review-style', get_template_directory_uri() . '/inc/exm1-post-style.css' );
	}
}
add_action( 'admin_enqueue_scripts', 'review_scripts' );




















add_action( 'add_meta_boxes', 'media_size_meta_box' );
add_action( 'save_post', 'media_size_meta_save_postdata' );
function media_size_meta_box() {
    add_meta_box( 
        'media_size_metabox',
        'Media Size',
        'media_size_custom_box',
        'post',
        'side',
        'default'
    );
}

function media_size_custom_box($post){
    wp_nonce_field( 'media_size_meta_field_nonce', 'media_size_meta_nonce' );
    $saved = get_post_meta( $post->ID, 'media_size', true);
    if( !$saved )
        $saved = 'normal';

    $fields = array(
        'fullwidth'  => 'Fullwidth Size',
        'big' => 'Big Size',
        'normal' => 'Normal Size',
        'none' => 'No media',
    );

    foreach($fields as $key => $label){
        printf(
            '<input type="radio" name="media_size" value="%1$s" id="media_size[%1$s]" %3$s />'.
            '<label for="media_size[%1$s]"> %2$s ' .
            '</label><br>',
            $key,
            $label,
            checked($saved, $key, false)
        );
    }
}

function media_size_meta_save_postdata( $post_id ){
      if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
          return;
		if ( ! isset( $_POST['media_size_meta_nonce'] ) ) {
			return;
		}
      if ( !wp_verify_nonce( $_POST['media_size_meta_nonce'], 'media_size_meta_field_nonce' ) )
          return;

      if ( isset($_POST['media_size']) && $_POST['media_size'] != '' ){
            update_post_meta( $post_id, 'media_size', $_POST['media_size'] );
      } 
}