<?php 
/**
 * Examiner help page
**/ 

add_action('admin_menu', 'exm1_theme_help');

function exm1_theme_help() {
	if( is_super_admin() ){
	add_theme_page('Portal V12 - Tutorial', 'Portal V12 - Tutorial Básico', 'read', 'exm1_help','exm1_help_page');
	wp_enqueue_style( 'Portal V12 um botão instalar estilo de widgets', get_template_directory_uri() . '/inc/exm1-widget-presets.css' );
}
}
function exm1_help_page(){ ?>
	<div class="container">
	
		<h3 class="center alt">Tutorial básico &ldquo;Portal V12 &rdquo;</h3>
		
		<hr>
		
		<h1 class="center">&ldquo;Portal V12&rdquo;</h1>
		
		<div class="borderTop">
			<div class="span-6 colborder info prepend-1">
				<p class="prepend-top">
					<strong>
					Criado em: 01/07/2020<br>
					Por: Page Up Solutions<br>
					
					</strong>
				</p>
			</div><!-- end div .span-6 -->		
	
			<div class="span-12 last">
				<p class="prepend-top append-0">Obrigado por adquirir o nosso tema. Se você tiver alguma dúvida que esteja além do escopo deste arquivo de ajuda, abra um Ticket em Nossa Central do Cliente ou pelo WhatsApp. Muito Obrigado!</p>
			</div>
		</div><!-- end div .borderTop -->
		
		<hr>
		
		<h2 id="toc" class="alt">Índice</h2>
		<ol class="alpha">
			<li><a href="#disclaimer">Aviso Legal</a></li>
			<li><a href="#installation">Instalação</a></li>
			<li><a href="#xmldata">Arquivo de importação XML</a></li>
			<li><a href="#themeoptions">Opções do Tema</a></li>
			<li><a href="#widgetareas">Widgets e áreas de widgets</a></li>
			<li><a href="#widgetdesc">Descrições de widget</a></li>
			<li><a href="#images">Imagens</a></li>
			<li><a href="#Videos">Vídeos</a></li>
			<li><a href="#reviews">Avaliações</a></li>
			<li><a href="#gallery">Galeria</a></li>		
		</ol>

		<hr>
		<h3 id="disclaimer"><strong>1) Isenção</strong> - <a href="#toc">subir</a></h3>
<p>Oferecemos suporte para o tema e seus principais recursos e funcionalidades. Não podemos garantir que esse tema funcione com todos os componentes e plugins de terceiros. O tema Portal V12 é apresentado como está.</p>

		<hr>
		<h3 id="installation"><strong>2) Instalação</strong> - <a href="#toc">subir</a></h3>
			<ol>
				<li>O Portal V12 já está pré-configurado e ajustado para o bom funcionamento.</li>
				<li>Deverá apenas fazer os ajustes necessários como Logotipos, Fontes, Cores, Categorias, Menu entre outros.
				<li>Não altere nada que possa ficar na dúvida ou não saber do que se trata.</li> <p> Para isto solicite o suporte através de nossa Central do cliente o pelo WhtasApp </p>
			</ol>


		<hr>
		<h3 id="xmldata"><strong>3) DADOS XML</strong> - <a href="#toc">subir</a></h3>
		<p>O tema Portal V12 vem com conteúdo fictício. Esse arquivo inclui postagens fictícias, páginas, menus, tags, categorias, uma foto fictícia e dois anúncios fictícios. Para instalar dados XML que possa ter de outro site Wordpress, vá em <b>Ferramentas> Importar</b>, clique no WordPress (rodar importador) e selecione o arquivo XML que possui. Depois, clique em Carregar arquivo e importe. Escolha um usuário ao qual atribuir as postagens e clique na caixa de seleção Fazer o download e importar anexos de arquivos e clique em enviar. <b> ATENÇÃO: </b> Este procedimento é apenas se queira importar seus Post ou paginas de um outro site em WORDPRESS.</p>
		
		<hr>
		<h3 id="themeoptions"><strong>4) Opções do Tema</strong> - <a href="#toc">subir</a></h3>
		<p>O Portal V12 vem com uma infinidade de opções que permitem brincar com o design e o layout sem tocar no código. Para editar as Opções do tema, vá em <b>Aparência>>Personalizar</b>.</p>
			<ol>
				<li><strong>Título do site, slogan e rodapé</strong><p>- É aqui que você define o título do site, o slogan e o texto dos direitos autorais no rodapé. Praticamente auto-explicativo.</p></li>
				
				<li><strong>Opções de logotipo</strong>
<p>	- É aqui que você carrega o logotipo principal e o rodapé. Além disso, você pode enviar seu favicon, ícone do Apple Touch e a imagem do Facebook para sua página inicial. O logotipo deve ter uma imagem PNG de 307x140 pixels. O favicon deve ser uma imagem PNG/GIF de 16x16 pixels. O ícone do toque da Apple deve ter 129x129 pixels PNG/JPG e a imagem do Facebook deve ter 486x254 pixels.
</p></li>

<li><strong>Cores</strong>
<p><strong>- Cor da borda do menu</strong>: é aqui que você altera a cor das bordas de 1 px no menu.</p>
<p><strong>- Cor do plano de fundo do menu</strong>: é aqui que você altera a cor do plano de fundo do cabeçalho.</p>
<p><strong>- Cor do plano de fundo do logotipo</strong>: selecione a cor do plano de fundo para o logotipo.</p>
<p><strong>- Cor do título das postagens principais</strong>: selecione a cor dos títulos das postagens no cabeçalho.</p>
<p><strong>- Cor da categoria das postagens principais</strong>: selecione a cor da categoria dos títulos das postagens no cabeçalho.</p>
<p><strong>- Cor do plano de fundo das postagens principais</strong>: selecione a cor do plano de fundo dos títulos das postagens no cabeçalho.</p>
<p><strong>- Cor do cursor do menu:</strong> use esta opção para alterar a cor dos itens de menu quando os usuários passarem o mouse sobre eles.</p>
<p><strong>- Cor da fonte do menu:</strong> selecione a cor da fonte no menu.</p>
<p><strong>- Cor principal:</strong> essa opção permite alterar a cor principal do tema, como as categorias e links em todo o site e alguns pequenos detalhes.</p>
<p><strong>- Cor do título do widget:</strong> selecione a cor para os títulos do widget em todo o site.</p>
<p><strong>- Cor do gradiente de sobreposição de imagem 1:</strong> é aqui que você seleciona uma das cores para o gradiente que sobrepõe as imagens.</p>
<p><strong>- Cor da sobreposição do gradiente de imagem 2:</strong> é aqui que você seleciona a outra cor para o gradiente que sobrepõe as imagens.</p>
<p><strong>- Cor do plano de fundo:</strong> é a cor do plano de fundo do site.</p>
<p><strong>- Cor do ícone de pesquisa:</strong> é aqui que você seleciona a cor do ícone de pesquisa, que pode ser preto ou branco.</p>
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika1.jpg"/>
</li>				

<li><strong>Design</strong>
<p><strong>- Direção do gradiente:</strong> Aqui você tem uma dúzia de opções que permitem escolher qual direção o gradiente deve ter.</p>
<p><strong>- Largura do corpo:</strong> é aqui que você seleciona a largura do site basicamente. Existem 3 opções, 1903px (largura total), 1560px e 1290px. Uma coisa a lembrar é que, se você alterar o tamanho da largura do corpo de menor para maior e já tiver carregado as imagens antes, precisará recarregá-las com o tamanho adequado ou processar o plug-in de miniaturas regeneradas.</p>
<p><strong>- Opacidade do gradiente:</strong> é aqui que você define o nível de opacidade do gradiente.</p>
<p><strong>- Transição do Slider:</strong> você tem alguns efeitos de carregamento do slider (transições de controle deslizante) para escolher.</p>
<p><strong>- Efeito de imagem:</strong> esta opção altera o efeito que aparece quando os usuários passam o mouse sobre as imagens no seu site. Você pode selecionar uma das 5 opções disponíveis.</p>
<p><strong>- Menu fixo:</strong> aqui você pode ativar ou desativar a opção do menu, se você deseja que ele siga o usuário quando ele estiver rolando a tela para baixo ou não.</p>
<p><strong>- Efeito de carregamento de widget:</strong> aqui você seleciona a maneira como os widgets são carregados quando entram na janela de exibição. Existem 10 opções que você pode escolher.</p>
</li>

<li><strong>Tipografia/Fonte</strong>
<p><strong>- Fonte principal:</strong> é aqui que você seleciona a fonte para o seu site. A fonte principal está presente em todo o site.</p>
<p><strong>- Fonte do menu:</strong> esta é a fonte apenas para o menu.</p>
<p><strong>- Peso da fonte do menu:</strong> é aqui que você determina a fonte para o menu. Você pode selecionar fonte regular, semi-negrito e negrito.</p>
<p><strong>- Tamanho da fonte do menu:</strong> Aqui você pode selecionar o tamanho da fonte do menu.</p>
<p><strong>- Fonte do título do widget:</strong> é aqui que você altera a fonte apenas para os títulos do widget.</p>
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika2.jpg"/>
</li>

<li><strong>Postagens no cabeçalho</strong>
<p><strong>- Categoria das postagens de cabeçalho:</strong> é aqui que você seleciona o que as postagens de cabeçalho devem exibir.</p>
</li>

<li><strong>Opções da página de postagem</strong>
<p>- Como o título sugere, aqui você tem as opções para a página de postagem. Basicamente, você pode decidir se deseja exibir ou ocultar os botões sociais, tags, comentários e links de navegação (próxima postagem/postagem anterior), etc. Também aqui você determina o tamanho da fonte da área de conteúdo e se o título da página de postagem deve estar em maiúsculas ou não. Outra opção que você tem aqui é selecionar pelo que as postagens relacionadas na parte inferior da página são determinadas. Você pode selecionar postagens relacionadas por categoria, tags ou autor.
</p></li>

<li><strong>Categoria e opções de página de TV</strong>

<p>- Isso é tudo sobre a categoria e as páginas de TV. Aqui, você determina quantas postagens devem estar visíveis por página de categoria, se a própria página de categoria deve começar com uma imagem grande, exibindo os 4 artigos mais populares desse mês/semana/dia e que tipo de estilo de blogroll deve retratar as demais postagens na página página. Você também pode selecionar o que a página de categoria deve exibir na parte inferior da página, outro conjunto de postagens populares e, em caso afirmativo, por qual período de tempo. Você também pode selecionar as postagens populares da semana passada, do mês passado ou para sempre. Quanto à página de TV aqui, você seleciona o estilo do widget que exibe as postagens de vídeo no vídeo principal. Você pode selecionar um dos três estilos.
</p></li>

<li><strong>Traduzir</strong>
<p>- Se o idioma do seu site não for o português/Brasil, é aqui que você configura a tradução. Existem algumas palavras em todo o site, como ler mais, pesquisar, compartilhar etc. que você pode querer traduzir para o seu idioma ou personalizar a palavra.
</p>
</li>

<li><strong>Configurações redes sociais</strong>
<p>- É aqui que você preenche suas contas das redes sociais. Basta digitar seu nome de usuário/identificador na plataforma de mídia social apropriada, e o restante o sistema cuidará de si.</p>
</li>
	
<li><strong>Espaços Publicitários</strong>
<p>- Aqui voc~e terá 3 espaços fixos de Publicidades de destaque - Anuncio no Cabeçalho/Anuncio no Rodapé/Anuncios em Posts. Nestes campos os banners deverão ser aplicadas com chamadas HTML. Deixamos um exemplo, caso tenha dúvidas solicite ao suporte mais informações.
</p></li>

<li><strong>Imagem de fundo</strong>
<p>- Se você não quiser uma cor sólida para o plano de fundo, poderá enviar uma imagem. Seja uma bela paisagem, um horizonte legal da cidade ou um padrão sutil, aqui é onde você faz.</p></li>


<li><strong>Navegação</strong>
<p>- O Portal V12 possui espaço predefinido para você colocar 2 menus. Aqui você escolhe onde exibir os menus que você criou. Veja a captura de tela abaixo para referência. Selecione qual menu aparece em cada local. Você pode editar o conteúdo do menu na tela Menus na seção Aparência. Para mais informações sobre como usar o recurso de menu personalizado do Wordpress, <a href="http://codex.wordpress.org/Appearance_Menus_Screen">clique aqui</a>. 
(http://codex.wordpress.org/Appearance_Menus_Screen)
</p></li>		
</ol>



	<hr>
		<h3 id="widgetareas"><strong>5) Widgets e áreas de widgets</strong> - <a href="#toc">subir</a></h3>
	<p>O Portal V12 vem com 24 widgets personalizados que você pode usar em quase todos os lugares. Basicamente, cada widget se encaixa em todas as áreas, dependendo do tamanho que você selecionar, para que você possa experimentar. Para ativar um widget, vá para <b>Aparência>>Widgets</b> e arraste e solte um widget da caixa Widgets disponíveis nas áreas do widget. Ou você pode fazer o mesmo, indo em <b>Aparência>>Personalizar</b>, onde pode ver a área de widgets na parte inferior do menu. Dessa forma, você pode ver os widgets na visualização ao vivo imediatamente.</p>
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika3.jpg"/>


<hr>
		<h3 id="widgetdesc"><strong>6) Descrições dos widgets</strong> - <a href="#toc">subir</a></h3>
	<p>Como mencionamos anteriormente, você pode colocar praticamente qualquer widget em qualquer lugar. Sinta-se à vontade para experimentar seu layout ou use um dos layouts sugeridos que já criamos. Lembre-se de que quase todos os widgets podem ter diferentes larguras, como mostrado no exemplo abaixo. Ao usar widgets como blocos de lego, é assim que você basicamente constrói seu site com o Portal V12</p>
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika4.jpg"/>
			<ol>
<li><strong>- Super Slider</strong><p>O super slider exibe 3 postagens ao mesmo tempo. Este widget possui 2 formulários, você pode selecionar a largura total ou a largura do corpo. Além disso, você pode especificar quantos slides o widget deve exibir.</p></li>
 
<li><strong>- Slider</strong>
<p>Este é o widget de slider típico. Ele exibe postagens com base em categorias. Você também pode selecionar se as setas de controle estão visíveis no slidere ou usar as setas como uma navegação.</p></li>

<li><strong>- Categoria em destaque com links</strong>
<p>- Um widget que exibe postagens de uma categoria de sua escolha. Digite um título para este widget e selecione a categoria que você gostaria de usar. A última postagem dessa categoria será exibida com uma imagem maior. Você também pode selecionar "Todas as categorias" para exibir as postagens mais recentes de todas as categorias em seu site.</p></li>

<li><strong>- Carousel Widget</strong>
<p>Este widget exibe postagens de uma categoria de sua escolha. Digite um título para este widget e selecione a categoria que você gostaria de usar. Você também pode selecionar "Todas as categorias" para exibir as postagens mais recentes do seu site. Há também uma opção que permite escolher quantas postagens você deseja exibir e se você deseja que o autor dessas postagens fique visível.</p></li>

<li><strong>- Imagens em destaque grandes</strong>
<p>Este widget exibe postagens com imagens maiores. Ele também pode exibir apenas suas postagens de revisão ou selecionar uma das categorias. Se você deseja exibir comentários, marque a caixa 'filtrar comentários'. Há também uma opção que permite escolher quantas postagens devem estar visíveis. E a opção de decidir se você deseja que os autores, a data e os trechos de texto das postagens sejam visíveis.</p></li>

<li><strong>- Imagens em destaque enormes</strong>
<p>Este widget exibe postagens com imagens ainda maiores. Cada postagem exibida nesses widgets ocupa 2/4 do corpo, portanto, ela vem apenas em 2/4 ou 4/4 de largura. Ele também pode exibir apenas suas postagens de revisão ou selecionar uma das categorias. Se você deseja exibir comentários, marque a caixa 'filtrar comentários'. Há também uma opção que permite escolher quantas postagens devem estar visíveis. E a opção de decidir se você deseja que o autor e a data das postagens sejam visíveis.</p></li>

<li><strong>- Widget Shortcode e suporte de linha</strong>
<p>Este é um widget que permite colar os códigos de acesso que você deseja usar no tema. Você pode selecionar o tamanho dele, certificando-se de que não atrapalhe o layout. Além disso, você pode usar este widget para endireitá-los. Por exemplo, se você deseja que seus widgets estejam alinhados, mas um espaço vazio criado pelos widgets acima não permite que os widgets se alinhem, use esse widget vazio, selecione seu tamanho e ele funcionará como uma linha invisível que manterá o widgets abaixo dele alinhados. </p></li>

<li><strong>- Título do Widget</strong>
<p>Este widget é útil quando você deseja usar vários widgets e ter um título para eles. Coloque-o acima dos widgets que você deseja agrupar com o mesmo título e selecione a qual categoria ele deve se vincular. Além disso, você pode ter uma legenda que descreve a categoria.</p></li>

<li><strong>- Ticker</strong>
<p>Este é um widget de ticker típico que exibe as últimas notícias ou qualquer categoria que você selecionar para ele. Pode ter largura total ou a largura do corpo, tornando-o perfeito para você combinar com outros widgets. Você também pode adicionar um pequeno sinal ou palavra que separará as postagens.</p></li>

<li><strong>- Blogroll 1</strong>
<p>Um widget típico de postagens de blog, que exibe suas postagens em um rolo. Você pode selecionar quantas postagens deseja exibir e, é claro, qual categoria elas devem ser. Além disso, o comprimento do trecho é determinado por você e a visibilidade dos autores e a data.</p></li>

<li><strong>- Blogroll 2</strong>
<p>Outro widget que exibe postagens no estilo de blog, apenas com imagens muito maiores. Você tem as mesmas opções que o widget anterior do Blogroll 1, como a visibilidade do autor, a data e o número de postagens que ele deve exibir.</p></li>

<li><strong>- Imagens em destaque pequenas</strong>
<p>Este widget exibe uma determinada categoria de sua escolha e você tem a opção de selecionar a visibilidade do autor e a data. Além disso, você pode selecionar quantas postagens serão exibidas e a opção de filtrar apenas as revisões.</p></li>

<li><strong>- Guias Widget</strong>
<p>Este é um widget clássico de tabulação, exibindo as postagens mais recentes, as mais populares e os últimos comentários de todo o site. Você tem a opção de alterar o título de cada uma delas e selecionar quantas postagens devem ser exibida.</p></li>

<li><strong>- Widget de TV</strong>
<p>Este widget exibe automaticamente os vídeos mais recentes que você enviou. Quando um visitante clica no vídeo, ele é levado diretamente para a página do vídeo. Você pode definir quantos dos seus vídeos mais recentes devem estar visíveis no widget.</p>
</li>

<li><strong>- Widget TV-Ajax</strong>
<p>Igual ao widget de TV anterior, apenas este exibe os vídeos diretamente. Isso significa que, quando você clica nele, o vídeo é reproduzido imediatamente, em vez de levá-lo à página de postagem do vídeo. Também possui um carrossel, para que o usuário possa selecionar com facilidade os vídeos mais recentes que você enviou.</p></li>

<li><strong>- Posts mais populares/visualizados</strong>
<p>Um widget simples que exibe as postagens mais populares/visitadas no seu site. Você também pode configurar o número de postagens exibidas.</p></li>

<li><strong>- Newsroll</strong>
<p>Um widget simples que exibe as postagens mais recentes em seu site. Você também pode configurar o número de postagens que deve exibir.</p></li>

<li><strong>- Widget Social (Redes Sociais)</strong>
<p>Este widget exibe suas mídias sociais. Dependendo da mídia social que você deseja configurar, você precisará inserir a alça, chave, ID, etc. Este widget possui 2 formulários, você pode alterá-lo selecionando o layout vertical ou horizontal.</p></li>

<li><strong>- Miniaturas</strong>
<p>Assim como o widget anterior, ele exibe as postagens mais recentes de uma categoria ou as postagens mais recentes em geral. A diferença é que essas postagens são exibidas com pequenas miniaturas. Você pode definir quantos deles devem estar visíveis.</p></li>

<li><strong>- Postagens de salto</strong>
<p>Esse é o widget de aparência elegante, cujas postagens saltam para cima e mudam de cor quando você passa o mouse sobre elas. Você pode atribuir uma categoria a esse widget ou defini-la como Todas as categorias, o que basicamente significa que o widget exibirá suas postagens mais recentes.</p></li>

<li><strong>- Mais comentado</strong>
<p>Um widget simples que exibe as postagens mais comentadas em seu site, juntamente com o número de comentários.</p> </li>

<li><strong>- Widget Sobre nós</strong>
<p>Como o próprio nome sugere, esses widgets permitem que você escreva algo sobre si mesmo, para que seus visitantes possam conhecê-lo melhor.</p></li>

<li><strong>- Widget de anúncio</strong>
<p>É aqui que você coloca seus anúncios. Apenas copie o código do anúncio no campo apropriado ou cole o URL da imagem e para onde deve apontar e você terá o anúncio pronto.</p></li>

<li><strong>- Widget de vídeo</strong>
<p>Este widget exibe um vídeo que pode ser reproduzido diretamente na página inicial ou onde quer que você o coloque. Basta adicionar um link ao vídeo e pronto.</p></li>
 
			</ol>

<hr>
		<h3 id="images"><strong>7) Imagens</strong> - <a href="#toc">subir</a></h3>
	<p>O Portal V12 usa o recurso embutido de imagem em destaque do Wordpress para lidar com o gerenciamento de imagens. O tamanho recomendado para as imagens serem exibidas corretamente no site é de 900x560. No entanto, tudo depende se você usa a opção de largura total para a imagem com fatura da página de postagem e/ou o tamanho do corpo da largura total. Nesse caso, você precisará enviar imagens maiores que isso. Para definir a imagem em destaque de um post, vá para <b>Posts>>Adicionar nova<b> (ou edite um post existente) e clique na imagem em destaque na caixa de imagem em destaque. Se a imagem desejada ainda não estiver carregada, clique em Carregar Imagem, selecione uma e clique em Definir como Imagem em Destaque. O tema Portal V12 cuidará do resto ao gerar as miniaturas menores que aparecem nos vários locais do site.
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika5.jpg"/>
</p>

		<hr>
		
        <h3 id="mediasize"><strong>8) Tamanho da mídia</strong> - <a href="#toc">subir</a></h3>
	<p>O Portal V12 permite escolher entre algumas opções, qual o tamanho da imagem em destaque. Você pode selecionar entre largura total, largura do corpo, normal e sem mídia. Dependendo do que você selecionou, faça o upload da imagem com o tamanho adequado.
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika6.jpg"/>
</p>

		<hr>

		<h3 id="Videos"><strong>9) Vídeos</strong> - <a href="#toc">subir</a></h3>
	<p>O Portal V12 usa o recurso de vídeo em destaque incorporado do Wordpress para facilitar o gerenciamento de vídeo. Ao criar uma postagem, selecione 'vídeo' em opções de 'formato' e simplesmente copie o link do vídeo e cole-o na área Vídeo em destaque. O Portal V12 cuidará do resto e seu vídeo aparecerá automaticamente também na página do vídeo. A página de vídeo é basicamente uma página que contém todos os vídeos dos seus artigos, em um layout agradável que facilita a navegação por eles e também é mais agradável de assistir. Para ter a página Vídeo (TV), certifique-se de que, ao acessar <b>Aparência>>Menus</b>, no canto direito da tela, em 'Opções da tela', marque a caixa de formato. Em seguida, basta adicionar o formato de vídeo ao menu.
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika7.jpg"/>
</p>

		<hr>
		
		<h3 id="reviews"><strong>10) Avaliações</strong> - <a href="#toc">subir</a></h3>
	<p>É realmente fácil configurar um post de revisão. Assim como a publicação em vídeo, tudo o que você precisa fazer é selecionar revisão nas opções de formato da página de publicação. Depois de fazer isso, novas opções aparecerão na área de texto. Aqui, você pode fazer o upload da imagem e fornecer o nome do assunto que está analisando e adicionar alguns prós e contras breves (bons e ruins). Também aqui você adiciona quantos parâmetros o assunto será revisado e quais números ele pontua em cada um. O valor total das pontuações será resumido e mostrado sobre a imagem.
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika8.jpg"/>
</p>
		<hr>

		<h3 id="gallery"><strong>11) Galeria</strong> - <a href="#toc">subir</a></h3>
	<p>Com o Portal V12, é realmente fácil configurar uma página da galeria. Tudo o que você precisa fazer é selecionar o formato da galeria no lado direito e, em seguida, basta fazer o upload das imagens no novo campo da galeria que é aberto na área de conteúdo.
<img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/help/slika9.jpg"/>
</p>
				
		<p><strong>MUITO OBRIGADO</strong></p>
<p>Mais uma vez, muito obrigado por adquirir/contratar este tema. Como eu disse no começo, teremos prazer em ajudá-lo se você tiver alguma dúvida relacionada a esse tema. Faremos o nosso melhor para ajudar.</p>
		
		<p class="append-bottom alt large"><strong>Page Up Solutions</strong></p>
		<p><a href="#toc">Voltar par o Índice</a></p>
		
		<hr class="space">
	</div><!-- end div .container -->
<?php } ?>