<!-- 
	PLATAFORMA PORTAL DE NOTÍCIAS
	PORTAL DE NOTÍCIAS ADMINISTRÁVEL "PORTAL V12"
	HTTPS://WWW.PAGEUP-SOLUTIONS.COM.BR 
-->
<?php 
/**
 * Examiner theme header
**/ 
?>
<!DOCTYPE html>
<html <?php language_attributes();?>><head>
<meta http-equiv="content-type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<!--viewport-->
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<!--charset-->
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
<!--rss-comments-->
<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('comments_rss2_url') ?>"/>
<!--rss-->
<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
<!--atom-->
<link rel="alternate" type="application/atom+xml" title="Atom" href="<?php bloginfo('atom_url'); ?>" />
<!--pingback-->
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<!--Facebook Open Graph-->
<?php if ( defined('WPSEO_VERSION') ) {}else{?>
<!--FB page title-->
<meta property="og:title" content="<?php if (! function_exists('bp_is_active') ) {if (is_single() || is_page()) {echo esc_attr(get_the_title());} else {bloginfo('name');}}else {if (is_single() || is_page() && !is_buddypress()) {echo esc_attr(get_the_title());} elseif(is_buddypress()){wp_title();} else {bloginfo('name');}} ?>" />
<!--FB description-->
<meta property="og:description" content="<?php if (is_single()) {echo substr(strip_tags($post->post_content), 0, 200); echo '...';} else {bloginfo('description');} ?>"/>
<!--FB url-->
<meta property="og:url" content="<?php if ( is_home() || is_front_page() ){echo esc_url(home_url('/'));} else{the_permalink();} ?>"/>
<!--FB image-->
<meta property="og:image" content="<?php if (is_single()) {$fbthumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'slider-three'); echo esc_url($fbthumb[0]);} else {echo esc_url(get_option('exm1_facebook_default'));}?>" />
<!--FB type-->
<meta property="og:type" content="<?php if (is_single()) { echo "article"; } else { echo "website";} ?>"/>
<!--FB site name-->
<meta property="og:site_name" content="<?php bloginfo('name'); ?>"/>
<?php } ?>
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<header id="header">
		<div id="nav-wrapper">
		<div id="navigation" class="<?php echo esc_attr(get_option('exm1_fixed_menu')); ?> <?php echo esc_attr(get_option('exm1_header_type')); ?>">
			<div id="site-logo">
				<?php if (is_page_template('home-page.php') || is_page_template('alternative homepage.php') ) {?>
				<h1 class="big-logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
					<img src="<?php header_image(); ?>" height="<?php echo esc_attr(get_custom_header()->height); ?>" width="<?php echo esc_attr(get_custom_header()->width); ?>" alt="<?php bloginfo( 'name' ); ?>"/>
					</a>
				</h1>
				<!--big-logo-->
				<?php }else{?>
				<div class="big-logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
					<img src="<?php header_image(); ?>" height="<?php echo esc_attr(get_custom_header()->height); ?>" width="<?php echo esc_attr(get_custom_header()->width); ?>" alt="<?php bloginfo( 'name' ); ?>"/>
					</a>
				</div>
				<!--big-logo-->
				<?php }	?>
			</div>
			<!--site-logo-->
			<?php if(get_option( 'exm1_header_type' ) != 'small-header'){?>
			<div class="top-menu">
				<?php top_menu_posts();?>
				<div class="search-box">
					<?php get_search_form(); ?>
				</div>
				<!--search-box-->
			</div>
			<!-- top-menu -->
			<?php } ?>
			<nav id="main-nav">
				<div id="mob-menu">
					<div class="mob-menu-button">
					</div>
					<!-- mob-menu-button -->
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img src="<?php header_image(); ?>" height="<?php echo esc_attr(get_custom_header()->height); ?>" width="<?php echo esc_attr(get_custom_header()->width); ?>" alt="<?php bloginfo( 'name' ); ?>"/>
					</a>
					<div class="search-box">
						<?php get_search_form(); ?>
					</div>
					<!--search-box-->

				</div>
				<!--mob-menu-->
				<?php if ( has_nav_menu( 'main-menu' ) ) {wp_nav_menu(array(
				'theme_location' => 'main-menu',
				'depth' => 10, 
				'fallback_cb'     => 'wp_page_menu',
				'walker' => new exm1_super_menu()
				));}else { echo '<span class="add-menu">ADICIONAR MENU</span>';}
				menu_share_icons();
				 ?>						
			</nav>
			<!--main-nav-->
		</div>
		<!--navigation-->
	</div>
	<!--nav-wrapper-->
	<script data-ad-client="ca-pub-7809550640915118" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
	</header>
<!--header-->
<?php $exm1_header_advert = get_option( 'exm1_header_advert' );if ( ! empty( $exm1_header_advert ) ){?>
<section class="header-advert ad-widget-sizes">
	<div class="ad-widget-box">
		<?php echo get_option( 'exm1_header_advert' );    ?>
	</div>	
	<!-- ad-widget-box -->
</section>
<!-- header-advert -->
<?php } ?>
<section id="wrapper" class="hfeed">